#ifndef KML_UTIL_KMODULES_PARSER_H
#define KML_UTIL_KMODULES_PARSER_H

#include "global_types.h"
#include "util/logger.h"

logger_loglevel_t kmodules_parser_parse_loglevel(int argc, char *argv[]);

error_code_t kmodules_parser_parse_args(int argc, char *argv[]);

error_code_t kmodules_parser_parse_config_early(void);

error_code_t kmodules_parser_parse_config_late(void);

error_code_t kmodules_parser_parse_kcmdline(const char *kmodule_name, char **parameters);

unsigned int kmodules_parser_get_max_worker_threads_cnt(void);

int kmodules_parser_get_timeout_ms(void);

unsigned int kmodules_parser_get_scheduled_modules_cnt(void);

#endif
